<?php
/***************************************************************************
 *                                reorder.php
 *                            -------------------
 *   begin                : Wednesday, Apr 2, 2003
 *   copyright            : (C) 2003 Matthijs van de Water
 *   email                : phpbb@matthijs.net
 *
 *   $Id: reorder.php,v 1.0.2 2003/04/11 13:48:31 mvdwater Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
define('IN_ADMIN', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_admin.'.$phpEx);

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8869-1">
<meta http-equiv="Content-Style-Type" content="text/css">
<link rel="stylesheet" href="http://area51.phpbb.com/phpBB22/adm/subSilver.css" type="text/css">
<style type="text/css">
th { background-image: url('http://area51.phpbb.com/phpBB22/adm/images/cellpic3.gif') }
td.cat	{ background-image: url('http://area51.phpbb.com/phpBB22/adm/images/cellpic1.gif') }
</style>
<title></title>
</head>
<body>
<table width="100%" cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td><img src="http://area51.phpbb.com/phpBB22/adm/images/header_left.jpg" width="200" height="60" alt="phpBB Logo" title="phpBB Logo" border="0"/></td><td width="100%" background="http://area51.phpbb.com/phpBB22/adm/images/header_bg.jpg" height="60" align="right" nowrap="nowrap"><span class="maintitle">Reorder Posts</span> &nbsp; &nbsp; &nbsp;</td>
	</tr>
</table>
<br clear="all" />
<p style="font-family: Courier, 'Courier New', sans-serif; font-size: 11px; margin-left: 10px;">
<?php
// Check for safe_mode and warn user if safe_mode is enabled
$ini_val = ( phpversion() >= '4.0.0' ) ? 'ini_get' : 'get_cfg_var';
if ( @$ini_val('safe_mode') )
{
	print "&gt; <span class='color: red;'>Warning:</span> safe mode enabled, this script may timeout! Disable safe mode if you have any problems.<br />\n";
}

if (!isset($HTTP_GET_VARS['start']))
{
	print "This tool will reorder your posts. Only use this if you're having problems (i.e. threads not sorted by date).<br /><b>Be sure to backup your database before continuing...</b><br />";
	print "<a href='" . $PHP_SELF . "?start=true'>Run reorder process</a><br />";
}
else
{
	
	// Unlimited execution time
	@set_time_limit(0);
	
	print "&gt; Querying maximum post_id ... ";
	flush();
	$sql = "SELECT MAX(post_id) AS max_id FROM " . POSTS_TABLE;
	$max_query = $db->sql_query($sql);
	if (!$max_query)
	{
		die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to query maximum post_id");
	}
	$row = $db->sql_fetchrow($max_query);
	$max_id = $row['max_id'];
	print "<span style='color: green;'>[SUCCESS]</span><br />\n";
	flush();
	
	// Will result in nearest (larger) exponent of 10 to max_id (i.e. 53421 will result in 100000)
	$add = pow(10, ceil(log10($max_id)));
	
	// Add large number to post_ids
	print "&gt; Adding " . $add . " to post_id's ... ";
	flush();
	
	$sql = "UPDATE " . POSTS_TABLE . " SET post_id = post_id + " . $add;
	if ( !$db->sql_query($sql) )
	{
		die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update " . POSTS_TABLE . " post_id's");
	}
	$sql = "UPDATE " . POSTS_TEXT_TABLE . " SET post_id = post_id + " . $add;
	if ( !$db->sql_query($sql) )
	{
		die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update " . POSTS_TEXT_TABLE . " post_id's");
	}
	$sql = "UPDATE " . TOPICS_TABLE . " SET topic_first_post_id = topic_first_post_id + " . $add;
	if ( !$db->sql_query($sql) )
	{
		die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update " . TOPICS_TABLE . " first_post_id's");
	}
	
	// Add large number to post_ids of search wordmatch table
	$sql = "UPDATE " . SEARCH_MATCH_TABLE . " SET post_id = post_id + " . $add;
	if ( !$db->sql_query($sql) )
	{
		die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update " . SEARCH_MATCH_TABLE . " post_id's");
	}
	
	print "<span style='color: green;'>[SUCCESS]</span><br />\n";
	flush();
	
	//
	// Reorder posts
	//
	
	print "&gt; Reordering posts, this might take a while:<br />\n&gt; .";
	flush();
	
	// Select old post_ids
	$sql = "SELECT post_id FROM " . POSTS_TABLE . " ORDER BY post_time ASC, post_id ASC";
	$post_query = $db->sql_query($sql);
	if (!$post_query)
	{
		die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to query posts");
	}
	
	$new_id = 1;
	while ($row = $db->sql_fetchrow($post_query))
	{
		$old_id = $row['post_id'];
		
		// Update posts table
		$sql = "UPDATE " . POSTS_TABLE . " SET post_id = " . $new_id . " WHERE post_id = " . $old_id;
		if ( !$db->sql_query($sql) )
		{
			die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update new post_id in posts_table for post " . $old_id);
		}
		
		// Update posts_text table
		$sql = "UPDATE " . POSTS_TEXT_TABLE . " SET post_id = " . $new_id . " WHERE post_id = " . $old_id;
		if ( !$db->sql_query($sql) )
		{
			die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update new post_id in posts_text table for post " . $old_id);
		}

		// Update topics table
		$sql = "UPDATE " . TOPICS_TABLE . " SET topic_first_post_id = " . $new_id . " WHERE topic_first_post_id = " . $old_id;
		if ( !$db->sql_query($sql) )
		{
			die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update new first_post_id in " . TOPICS_TABLE . " table for post " . $old_id);
		}
		
		// Update search wordmatch table
		$sql = "UPDATE " . SEARCH_MATCH_TABLE . " SET post_id = " . $new_id . " WHERE post_id = " . $old_id;
		if ( !$db->sql_query($sql) )
		{
			die("<span style='color: red;'>[FAILED]</span><br />\n<br />Unable to update new post_id in wordmatch table for post " . $old_id);
		}
		
		// Output some sort of status info
		if ($new_id % 8000 == 0)
		{
			print "<br />\n&gt; .";
			flush();
		}
		else if ($new_id % 100 == 0)
		{
			print ".";
			flush();
		}
		
		$new_id++;
	}
	
	print "<br />\n&gt; <span style='color: green;'>[SUCCESS]</span><br />\n";
	
	print "&gt; Updating last_post_id's of topics... ";
	flush();
	sync('all_topics');
	print "<span style='color: green;'>[SUCCESS]</span><br />\n";
	flush();
	
	print "&gt; Updating last_post_id's of forums... ";
	flush();
	sync('all_forums');
	print "<span style='color: green;'>[SUCCESS]</span><br />\n";
	flush();
	
	print "<br /><br />\n" ;
	
	print "<b>Reordering of posts completed.</b> Everything should now function correctly.<br />";
	print "It may be a good idea to do a full database backup and immediately restore this backup. This will resume new post_id's as expected (i.e. from $new_id instead of from $old_id).";
}
?>
</p>
<center>
<hr />
<span class="copyright">This tool is &copy; 2003 Matthijs van de Water (<a href="mailto:phpbb@matthijs.net">phpbb@matthijs.net</a>)<br />
<a href="http://www.phpbb.com/" target="_phpbb">phpBB</a> is &copy; 2002, 2003 phpBB Group</span>
</center>
</body>
</html>